// GPIO_Watchdog.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include <winbase.h>
#include <stdio.h>
#include <wchar.h>
#include <iostream>
#include ".\AR-B6002.h"

#define SLEEP 100

using namespace std;

unsigned short port;
unsigned char val[4];

struct _FuncTable {
  void (*func)(void);
  const char str[255];
};

static void showShortBits(unsigned char num)
{
  int i;
  int bits[8] = {0};

  for(i=0; i<8; i++) {
    if( (num & (0x1<<i) ) == (0x1<<i) )
      bits[i] = 1;
  }

  for(i=4; i<8; i++) {
    printf(" %d", bits[7-i]);
  }

  printf("\n\n");
  return;
}

void getGpio(void)
{
	unsigned char value = 0x0;

    /* GPI 0~3 */
    getInChLevel( GPIALL, &value);
    
	printf("GPIO IN, 0x%x\n", value);
    showShortBits(value);
 
    value = 0;
    
    /* GPO 0~3 */
    getOutChLevel( GPOALL, &value);
 
	printf("GPIO OUT, 0x%x\n", value);
    showShortBits(value);
        
    return;
}

void getWtd(void)
{
	unsigned char value = 0x0;

	value = getWtdTimer();
	printf("Watchdog Counter %3d\n\n", value );

	return;
}

void setWtd(void)
{
	int counter = 0x0;

	printf("Please input the numver of timer counter: ");
	scanf_s("%d", &counter);
	printf("\n");

	setWtdTimer((unsigned char) counter);
	getWtd();

	return;
}

void setGpioSub1(void)
{
				setOutChLevel( GPO0, 0x1);
				Sleep(SLEEP);
				getGpio();
}

void setGpioSub2(void)
{
				setOutChLevel( GPO1, 0x1);
				Sleep(SLEEP);
				getGpio();
}

void setGpioSub3(void)
{
				setOutChLevel( GPO2, 0x1);
				Sleep(SLEEP);
				getGpio();
}

void setGpioSub4(void)
{
				setOutChLevel( GPO3, 0x1);
				Sleep(SLEEP);
				getGpio();
}

void setGpioSub5(void)
{
				setOutChLevel( GPO0, 0x0);
				Sleep(SLEEP);
				getGpio();
}

void setGpioSub6(void)
{
				setOutChLevel( GPO1, 0x0);
				Sleep(SLEEP);
				getGpio();
}

void setGpioSub7(void)
{
				setOutChLevel( GPO2, 0x0);
				Sleep(SLEEP);
				getGpio();
}

void setGpioSub8(void)
{
				setOutChLevel( GPO3, 0x0);
				Sleep(SLEEP);
				getGpio();
}

static struct _FuncTable gpioSettingTable[] = {
	{setGpioSub1, "Set GPIO Ouput 0 to 1"},
	{setGpioSub2, "Set GPIO Ouput 1 to 1"},
	{setGpioSub3, "Set GPIO Ouput 2 to 1"},
	{setGpioSub4, "Set GPIO Ouput 3 to 1"},
	{setGpioSub5, "Set GPIO Ouput 0 to 0"},
	{setGpioSub6, "Set GPIO Ouput 1 to 0"},
	{setGpioSub7, "Set GPIO Ouput 2 to 0"},
	{setGpioSub8, "Set GPIO Ouput 3 to 0"},
	{getGpio, "Print GPIO status"}
};

void setGpio(void)
{
	int num = 0x0;
	int i;

SET_GPIO_CMD:
	printf("-------------------------------------------------\n");
	printf("(0) Back to Main Menu\n\n");

	for(i=0; i<(sizeof(gpioSettingTable)/sizeof(gpioSettingTable[0])); i++)
		printf("(%d) %s\n", i+1, gpioSettingTable[i].str);

	printf("-------------------------------------------------\n>> ");
	
	scanf_s("%d", &num);
	printf("\n");

	if( (num<0) || (num > (sizeof(gpioSettingTable)/sizeof(gpioSettingTable[0])))) {
		printf("Wrong number!\n\n");
		goto SET_GPIO_CMD;
	}

	if( num==0 )
		goto SET_GPIO_RET;

	gpioSettingTable[num-1].func();
	goto SET_GPIO_CMD;
	

SET_GPIO_RET:
	return;
}



static struct _FuncTable funcTable[] = {
	{getGpio, "Print GPIO status"},
	{setGpio, "Set GPIO Output."},
	{getWtd, "Get Watchdog Timer."},
	{setWtd, "Set Watchdog Timer."}
};


void printMainMenu(void)
{
	int i;
	
	printf("-------------------------------------------------\n");
    printf("(0) Exit\n\n");

	for(i=0; i<( sizeof(funcTable)/sizeof(funcTable[1]) ); i++)
		printf("(%d) %s\n", i+1, funcTable[i].str);
	
	printf("-------------------------------------------------\n>> ");

	return;
}


int _tmain(int argc, _TCHAR* argv[])
{
	bool result = false;
	int i=0;
	int num;

	unsigned char value = 0x0;

CMD_RETRY:
	printMainMenu();
	scanf_s("%d", &num);
	printf("\n");

	if( (num<0) || (num > sizeof(funcTable)/sizeof(funcTable[0])) ) {
		printf("Wrong number!\n\n");
		goto CMD_RETRY;
	}

	if( num==0 )
		goto APP_END;

	funcTable[num-1].func();
	goto CMD_RETRY;

APP_END:
    
	Sleep(SLEEP);
	return(0);
}

