// PWRPICDlg.h : header file
//

#pragma once
#include "afxcmn.h"
#include "afxwin.h"
#include ".\AR-B6002.h"


typedef unsigned char u8;

// CPWRPICDlg dialog
class CPWRPICDlg : public CDialog
{
// Construction
public:
	CPWRPICDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_PWRPIC_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
// pic variable	
	PicInfo ver; //pic version
	unsigned char ignition;  //0xA5 on ; 0x5A off
	unsigned char mode;		 //pic mode, 0~0xF
	float batVol; //10 bit DAC (5Volt reference)
	unsigned long softoff; //24 bit countdown counter
	unsigned long hardoff; //24 bit countdown counter
	unsigned char power_mode; //0xA5 ignition switch ; 0x5A remote switch

// Implementation
protected:
	HICON m_hIcon;
	
	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	CEdit m_Softoff_Edit;
public:
	CSpinButtonCtrl m_SoftSpin;
public:
	afx_msg void OnBnClickedApply();
public:
	CEdit m_Hardoff_Edit;
public:
	CSpinButtonCtrl m_HardSpin;
public:
	afx_msg void OnBnClickedDefault();
public:
	afx_msg void OnBnClickedIgnition();
public:
	afx_msg void OnBnClickedRemote();
	BOOL PWRPIC_Get_Ver(); // get pic version
	BOOL PWRPIC_Get_Ignition(unsigned char *ignition);
	BOOL PWRPIC_Get_Mode();
	BOOL PWRPIC_Get_Battery();
	BOOL PWRPIC_Set_SoftoffS(unsigned long val);
	BOOL PWRPIC_Get_Softoff();
	BOOL PWRPIC_Set_HardoffS(unsigned long val);
	BOOL PWRPIC_Get_Hardoff();
	BOOL PWRPIC_Set_Default();
	BOOL PWRPIC_Set_Power_Mode(unsigned char val);
	BOOL PWRPIC_Get_Power_Mode();
	char Do_Handshake(); //pic handshake

public:
	int m_Ignition;
public:
	afx_msg void OnBnClickedOk();
};